// control play
public class ConsolePlayer: IPlayer
{
    public IAction TakeTurn(Character character, Battle battle)
    {
        List<MenuOption<IAction>> options = new ();
        // make menu option for using standard attack on each opp
        List<Character> targets = FindTargets(character, battle);
     
        // add the rest option
        if(targets.Count > 0)
            options.Add(new MenuOption<IAction>($"Standard Attack({character.StandardAttack.Name})",
                new AttackAction(character, character.StandardAttack, targets[0])));
        options.Add(new MenuOption<IAction>("Rest", new RestAction(character)));
        
        IAction choice = ConsolePlus.PromptWithMenu($"What would you like {character.Name} to do?", options);
        return choice;
    }
    private static List<Character> FindTargets(Character character, Battle battle)
    {
        if (battle.Monsters.Characters.Contains(character))return battle.Heroes.Characters;
        else return battle.Monsters.Characters;
    }
}